package gov.va.med.mhv.admin.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.common.data.model.FacilityInfo;

@Repository
public interface FacilityInfoRepository extends JpaRepository<FacilityInfo, Long> {

	@Query("select info from FacilityInfo info order by info.name asc")
	List<FacilityInfo> getAllFacilityInfos();

	@Query("select info from FacilityInfo info where info.stationNumber = :stationNumber")
	List<FacilityInfo> queryByStationNumber(@Param("stationNumber") String stationNumber);

	@Query("select  info from FacilityInfo info where info.id = :id")
	FacilityInfo getFacilityInfoById(@Param("id") Long id);
}
